"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CategoriesService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const category_entity_1 = require("../../entities/category.entity");
let CategoriesService = class CategoriesService {
    categoryRepo;
    deactivate(id) {
        throw new Error('Method not implemented.');
    }
    activate(id) {
        throw new Error('Method not implemented.');
    }
    constructor(categoryRepo) {
        this.categoryRepo = categoryRepo;
    }
    toCategoryResponseDto(category) {
        return {
            id: category.id,
            name: category.name,
            description: category.description,
            image: category.image,
            createdAt: category.createdAt ?? new Date(),
            updatedAt: category.updatedAt ?? new Date(),
            productCount: category.products?.length ?? 0
        };
    }
    async create(createCategoryDto) {
        const existingCategory = await this.categoryRepo.findOne({
            where: { name: createCategoryDto.name },
        });
        if (existingCategory) {
            throw new common_1.ConflictException('Category with this name already exists');
        }
        const category = this.categoryRepo.create(createCategoryDto);
        const savedCategory = await this.categoryRepo.save(category);
        return this.toCategoryResponseDto(savedCategory);
    }
    async findAll() {
        const categories = await this.categoryRepo.find({
            relations: ['products'],
            order: { name: 'ASC' },
        });
        return categories.map(category => this.toCategoryResponseDto(category));
    }
    async findAllWithProducts() {
        const categories = await this.categoryRepo.find({
            relations: ['products'],
            order: { name: 'ASC' },
        });
        return categories.map(category => this.toCategoryResponseDto(category));
    }
    async findOne(id) {
        const category = await this.categoryRepo.findOne({
            where: { id },
            relations: ['products'],
        });
        if (!category) {
            throw new common_1.NotFoundException(`Category with ID ${id} not found`);
        }
        return this.toCategoryResponseDto(category);
    }
    async update(id, updateCategoryDto) {
        const category = await this.categoryRepo.findOne({ where: { id } });
        if (!category) {
            throw new common_1.NotFoundException(`Category with ID ${id} not found`);
        }
        if (updateCategoryDto.name && updateCategoryDto.name !== category.name) {
            const existingCategory = await this.categoryRepo.findOne({
                where: { name: updateCategoryDto.name },
            });
            if (existingCategory) {
                throw new common_1.ConflictException('Category with this name already exists');
            }
        }
        Object.assign(category, updateCategoryDto);
        const updatedCategory = await this.categoryRepo.save(category);
        return this.toCategoryResponseDto(updatedCategory);
    }
    async remove(id) {
        const category = await this.categoryRepo.findOne({
            where: { id },
            relations: ['products'],
        });
        if (!category) {
            throw new common_1.NotFoundException(`Category with ID ${id} not found`);
        }
        if (category.products && category.products.length > 0) {
            throw new common_1.ConflictException('Cannot delete category that has products.');
        }
        await this.categoryRepo.remove(category);
    }
    async searchByName(name) {
        const categories = await this.categoryRepo
            .createQueryBuilder('category')
            .where('category.name LIKE :name', { name: `%${name}%` })
            .leftJoinAndSelect('category.products', 'products')
            .getMany();
        return categories.map(category => this.toCategoryResponseDto(category));
    }
};
exports.CategoriesService = CategoriesService;
exports.CategoriesService = CategoriesService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(category_entity_1.Category)),
    __metadata("design:paramtypes", [typeorm_2.Repository])
], CategoriesService);
//# sourceMappingURL=categories.service.js.map